#include "typesiigs.r" 

/***/

#define MainWindow		$1000
#define AppLaunch		1
#define AppTriggerText	10
#define AppTriggerData	11
#define AppTargetText	12
#define AppTargetData	13
#define AppTimerText	14
#define AppTimerData	15
#define AppUnitText		16

/***/

#define AboutWindow		$2000
#define AboutOK			1
#define AboutText		2

/***/

/*------------------------ Startup Record -----------------------*/

resource rToolStartup (1)	{
	mode640,							/* master SCB */
	{ 	
        3,$0300,  /* misc tools */
        4,$0301,  /* quickdraw */
        5,$0302,  /* desk manager */
        6,$0300,  /* eventMgr */
        7,$0200,  /* scheduler */
/*      8,$0301,  /* sound tools */
/*      9,$0201,  /* ADB tools */
/*      10,$0202, /* SANE */
        11,$0200, /* int math */
        14,$0301, /* Window Manager */
        15,$0301, /* Menu Manager */
        16,$0301, /* Control Manager */
        18,$0301, /* QD Aux */
/*      19,$0300, /* print manager */
        20,$0301, /* LineEdit tool set */
        21,$0302, /* Dialog Manager */
        22,$0300, /* Scrap manager */
        23,$0301, /* standard file */
/*      25,$0104, /* NoteSynth */
/*      26,$0104, /* Note Seq */
        27,$0301, /* Font manager */
        28,$0301, /* list manager */
/*      29,$0101, /* ACE */
/*      32,$0103, /* Midi Tools */
/*      34,$0101  /* text edit */
	}
};


/*---------------------------------------------------------------------------*/
/*
/* About Window
/*
/* This is the template for the about window, with controls.
/*
/*---------------------------------------------------------------------------*/

resource rWindParam1 (AboutWindow) {
	fVis+fAlert,											/* Frame Bits			*/
	0,														/* title ID   			*/
	0,														/* ref Con    			*/
	{0,0,0,0},												/* Zoom Rect  			*/
	0,														/* color table id 		*/
	{0,0},													/* origin 				*/
	{0,0},													/* data size 			*/
	{0,0},													/* max height-width		*/
	{0,0},													/* scroll amount, hor,ver */
	{0,0},													/* page amount */
	0,														/* wInfo Ref Con */
	0,														/* wInfo height */
	{$15,$A0,$BA,$1E0},										/* window Position */
	infront,												/* wPlane */
	AboutWindow,											/* Control Ref */
	refIsResource*0x0100+resourceToResource  				/* descriptor */
};

/********/

resource rControlList (AboutWindow) {
	{
		AboutWindow+AboutText,
		AboutWindow+AboutOK
	}
};

/********/

resource rControlTemplate (AboutWindow+AboutText) {
	AboutText,
	{$10,$20,$81,$120},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsResource,		/* more flags */
		0,
		AboutWindow+AboutText
	}};
}; 

/********/

resource rTextForLETextBox2 (AboutWindow+AboutText) {
	TBCenterJust
	TBStyleOutline
	"AutoLaunch"
	TBEndOfLine
	TBStylePlain
	"A program to automatically launch freshly-built applications over the network."
	TBEndOfLine
	TBEndOfLine
	"by"
	TBEndOfLine
	"Eric Soldan"
	TBEndOfLine
	TBEndOfLine
	"Copyright Apple Computer, Inc."
	TBEndOfLine
	"All Rights Reserved"
	TBEndOfLine
	"Version 3.0"
};

/********/

resource rControlTemplate (AboutWindow+AboutOK) {
	AboutOK,
	{$88,$90,0,0},
	SimpleButtonControl{{
		DefaultButton,
		fCtlWantsEvents+fctlProcNotPtr+RefIsResource,
		0,						/* ref con */
		AboutWindow+AboutOK,	/* title ref */
		0,						/* color table not used */
		{"\015","\015",0,0}		/* key equiv */
	}};
};
resource rpString (AboutWindow+AboutOK) {"OK"};


/*---------------------------------------------------------------------------*/
/*
/* Main Window
/*
/* This is the template for the main window, with controls.
/*
/*---------------------------------------------------------------------------*/

resource rWindParam1 (MainWindow) {
	fTitle+fMove,									/* Frame Bits -- title is a drag */
	MainWindow,										/* title ID   			*/
	0,												/* ref Con    			*/
	{0,0,0,0},										/* Zoom Rect  			*/
	0,												/* color table id 		*/
	{0,0},											/* origin 				*/
	{0,0},											/* data size 			*/
	{0,0},											/* max height-width		*/
	{0,0},											/* scroll amount, hor,ver */
	{0,0},											/* page amount */
	0,												/* wInfo Ref Con */
	0,												/* wInfo height */
	{60,100,140,540},								/* window Position */
	infront,										/* wPlane */
	MainWindow,										/* Control Ref */
	refIsResource*0x0100+resourceToResource  		/* descriptor */
};
resource rPString (MainWindow) {"AutoLaunch"};

/********/

resource rControlList (MainWindow) {
	{
		MainWindow+AppLaunch,
		MainWindow+AppTriggerText,
		MainWindow+AppTriggerData,
		MainWindow+AppTargetText,
		MainWindow+AppTargetData,
		MainWindow+AppTimerText,
		MainWindow+AppTimerData,
		MainWindow+AppUnitText
	}
};

/********/

resource rControlTemplate (MainWindow+AppLaunch) {
	AppLaunch,
	{56,220-100,70,220+100},
	SimpleButtonControl{{
		DefaultButton,
		fCtlWantsEvents+fctlProcNotPtr+RefIsResource,
		0,					/* ref con */
		MainWindow+AppLaunch,	/* title ref */
		0,						/* color table not used */
		{"\015","\015",0,0}		/* key equiv */
	}};
};
resource rpString (MainWindow+AppLaunch) {"Launch Application"};

/********/

resource rControlTemplate (MainWindow+AppTriggerText) {
	AppTriggerText,
	{10,10,20,222},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsResource,		/* more flags */
		0,
		MainWindow+AppTriggerText
	}};
}; 
resource rTextForLETextBox2 (MainWindow+AppTriggerText) {
	"\$01J\$FF\$FFApplication trigger file:"
};

/********/

resource rControlTemplate (MainWindow+AppTriggerData) {
	AppTriggerData,
	{10,234,20,400},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsPtr,			/* more flags */
		0,									/* refCon */
		0,									/* no resource (RefIsPtr) */
		0,									/* text size */
		0									/* left justify */
	}};
}; 

/********/
/********/

resource rControlTemplate (MainWindow+AppTargetText) {
	AppTargetText,
	{20,10,30,222},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsResource,		/* more flags */
		0,
		MainWindow+AppTargetText
	}};
}; 
resource rTextForLETextBox2 (MainWindow+AppTargetText) {
	"\$01J\$FF\$FFApplication to launch:"
};

/********/

resource rControlTemplate (MainWindow+AppTargetData) {
	AppTargetData,
	{20,234,30,400},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsPtr,			/* more flags */
		0,									/* refCon */
		0,									/* no resource (RefIsPtr) */
		0,									/* text size */
		0									/* left justify */
	}};
}; 

/********/
/********/

resource rControlTemplate (MainWindow+AppTimerText) {
	AppTimerText,
	{36,10,46,222},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsResource,		/* more flags */
		0,
		MainWindow+AppTimerText
	}};
}; 
resource rTextForLETextBox2 (MainWindow+AppTimerText) {
	"\$01J\$FF\$FFTime between trigger tests:"
};

/********/

resource rControlTemplate (MainWindow+AppTimerData) {
	AppTimerData,
	{34,234,47,234+12+4*8},
	EditLineControl{{
		0,
		fctlCanBeTarget+fctlWantsEvents+fctlProcNotPtr+RefIsResource,
		0,
		4,								/* Max Length */
		MainWindow+AppTimerData
	}};
}; 
resource rPString (MainWindow+AppTimerData) {"1"};

/********/

resource rControlTemplate (MainWindow+AppUnitText) {
	AppUnitText,
	{36,234+12+4*8+12,46,400},
	StatTextControl{{
		ctlInactive,						/* flag */
		fctlProcNotPtr+RefIsResource,		/* more flags */
		0,
		MainWindow+AppUnitText
	}};
}; 
resource rTextForLETextBox2 (MainWindow+AppUnitText) {
	"(in seconds)"
};

/********/

















/*********************************************************************/
/*
/* 			Menus
/*
/*********************************************************************/

#define AppleMenuID		$901
#define FileMenuID		$902
#define EditMenuID		$903

#define UndoID 			250
#define CutID			251
#define CopyID 			252
#define PasteID 		253
#define ClearID 		254
#define CloseID			255

#define AboutID			301

#define ChooseTriggerID	401
#define ChooseTargetID	402
#define SaveLaunchID	403
#define QuitID			499

/********/

resource rMenuBar (1) {
	{
		AppleMenuID,FileMenuID,EditMenuID
	};
};

/********/

resource rMenu (AppleMenuID) {
	AppleMenuID,0xA008,AppleMenuID,{
		AboutID
	};
};
resource rPString (AppleMenuID) {"@"};

/********/

resource rMenu (FileMenuID)	{
	FileMenuID,0xA008,FileMenuID,{
		ChooseTriggerID,ChooseTargetID,SaveLaunchID,CloseID,QuitID
	};
};
resource rPString (FileMenuID) {" File "};

/********/

resource rMenu (EditMenuID)	{
	EditMenuID,0xA008,EditMenuID,{
		UndoID,CutID,CopyID,PasteID,ClearID
	};
};
resource rPString (EditMenuID) {" Edit "};

/********/

resource rMenuItem (AboutID) {AboutID,"","",0,0x8040,AboutID};
resource rPString (AboutID) {"About AutoLaunch..."};

/********/

resource rMenuItem (ChooseTriggerID) {ChooseTriggerID,"T","t",0,0x8000,ChooseTriggerID};
resource rPString (ChooseTriggerID) {"Choose Trigger File..."};

resource rMenuItem (ChooseTargetID) {ChooseTargetID,"L","l",0,0x8000,ChooseTargetID};
resource rPString (ChooseTargetID) {"Choose Application to Launch..."};

resource rMenuItem (SaveLaunchID) {SaveLaunchID,"S","s",0,0x8000,SaveLaunchID};
resource rPString (SaveLaunchID) {"Save Application Launch Info"};

resource rMenuItem (CloseID) {CloseID,"W","w",0,0x8040,CloseID};
resource rPString (CloseID) {"Close"};

resource rMenuItem (QuitID) {QuitID,"Q","q",0,0x8000,QuitID};
resource rPString (QuitID) {"Quit"};

/********/

resource rMenuItem (UndoID) {UndoID,"","",0,0x8040,UndoID};
resource rPString (UndoID) {"Undo"};

resource rMenuItem (CutID) {CutID,"X","x",0,0x8000,CutID};
resource rPString (CutID) {"Cut"};

resource rMenuItem (CopyID)	{CopyID,"C","c",0,0x8000,CopyID};
resource rPString (CopyID) {"Copy"};

resource rMenuItem (PasteID) {PasteID,"V","v",0,0x8000,PasteID};
resource rPString (PasteID) {"Paste"};

resource rMenuItem (ClearID) {ClearID,"","",0,0x8000,ClearID};
resource rPString (ClearID) {"Clear"};

/*************************************************************************/

